function [p]= v_to_p(v,rm,r0,p0,lat)
%
%  This function estimates central pressure (hPa) given maximum 1-minute 
%  winds at 10 m altitude (m/s), radius of maximum winds (km), outer storm  
%  radius (km), ambient surface pressure (hPa), and latitude (degrees). 
%  The inputs can be arrays. 
%
%  Copyright 2009 WindRiskTech L.L.C.
%  Last modified November, 2014
%
%------------------------------------------------------------------------ 
Ts=300;     % Assumed SST (K) used in zero moist PV vortex
To=205;     % Assumed outflow temperature (K) used in zero moist PV vortex
H=0.8;      % Assumed environmental relative humidity at 10 m
a=0.7;      % Factor governing concavity of V inside r_m. Equals one for
            %  solid body rotation; less than one for concavity. 
reduc=0.84; % Factor to reduce gradient wind by to get surface wind            
%------------------------------------------------------------------------
%
pi=acos(-1);
pifac=pi./180;
f=(pi./(6.*3600)).*sin(pifac.*lat);
Rd=287;
Lv=2.5e6;
Tc=Ts-273.15;
es=6.112.*exp(17.67.*Tc./(243.5+Tc));
qa=H.*0.622.*es./p0;
ep=(Ts-To)./Ts;
r0=1e3.*r0;
rm=1e3.*rm;
%
vbal=v./reduc;   %  Find gradient wind from 10 m wind
%
fac1=1./(Rd.*To-ep.*Lv*qa);
fac2=0.5.*(a./(Rd.*Ts)+fac1);
fac3=fac1.*0.25.*f.^2.*(rm.^2-r0.^2);
%
p=p0.*exp(-fac2.*(vbal.^2+f.*vbal.*rm)-fac3);
%