function [ transfactor ] = transfunction( latitude )
%
% This produces a function (transfactor) of the translation velocity that is 
% added to the circular wind speeds of the synthetic track sets. 
% Copyright WindRiskTech, 2011
% Last modified May, 2014
% Absolute value applied to latitude, November, 2020
%-------------------------------------------------------------------------
transfac=0.8;
%transcap=1.2;
transcap=1;   % Changed to 1 on May 30th 2014
amplitude=0.35;
%amplitude=0;
centerlat=35;
latscale=10;
%
transfactor=transfac+amplitude.*(1+tanh((abs(latitude)-centerlat)./latscale));
transfactor=min(transfactor,transcap);
%
end

