function [ q900, q600 ] = qs900( T600 )
% Calculates saturation specific humidity at 600 hPa and saturation
% specific humidity at 900 hPa given 600 hPa T (K) and assuming a moist
% adiabatic lapse rate.  January, 2012.
%-----------------------------------------------------------------------
pref=1000;    %  Pressure to find qs at
%
T600=max(T600,200);
c1=0.622.*2.5e6./1e3;
c2=2.5e6.^2./(1000.*461);
c3=log(pref./600);
Tc=T600-273.15;
es=6.112.*exp(17.67.*Tc./(243.5+Tc));
q600=0.622.*es./600;
clear es
q900=q600;   % (first guess)
[qn,qm]=size(q600);
for i=1:qn
    for j=1:qm
         a=c3.*(c1./T600(i,j)-1);
         b=c2./(T600(i,j).^2);
         if T600(i,j) >= 255
             for it=1:10
                q900new=q600(i,j)+a./b-log(q900(i,j)./q600(i,j))./b;
                q900new=max(q900new,1e-6);
                q900(i,j)=0.5.*(q900new+q900(i,j));
             end   
         else
             for it=1:10
                q900new=q600(i,j).*exp(a-b.*(q900(i,j)-q600(i,j)));
                q900new=max(q900new,1e-6);
                q900(i,j)=0.5.*(q900new+q900(i,j));
             end   
         end 
    end
end
end

