%
%  This script plots time series of wind speed and direction at a given 
%  point of interest, specified by maximum lifetime wind, by maximum wind at 
%  the point of interest or the intersection points of tracks with a 
%  specified set of line segments, or by track number.  
%  The script "Prep" must be run first.  
%  November 2008
%  Copyright 2009 WindRiskTech L.L.C.; Last modified March, 2020
%-------------------------------------------------------------------------
%
params    %  Load parameters
%
if strcmp(randfac,'y')
    if exist('tmr3','var')
        stop(tmr3)
        delete(tmr3)
        clear tmr3
    end   
    tmr3=timer;
    set(tmr3,'startdelay',3);
    set(tmr3,'timerfcn','try; delete(hms); catch err; end')
    hms=msgbox('Caution: Random draw for wind radii turned on; results will differ with each call');
    start(tmr3)
end
%clear x* y* u* v* date offset pres daym hour jmax
%clear ax h1 h2 month* day* tit* ntstring
clf('reset')
%
if exist('shearstore','var') == 0
    shape='circ';
    load('temp.mat')
%else
    %load temp dir1  %  These two lines commented out May 5 2016
end        
rmstore1=rmstore.*magfac;
rmsestore1=rmsestore.*magfac;
%  
% Randomize radii of maximum wind
%
if strcmp(randfac,'y')
    [nrm,mrm]=size(rmstore);
    rfac=outer(nrm,mrm);
    rmstore1=rmstore1.*rfac;
    rmsestore1=rmsestore1.*rfac;
end
fs3='sorted';
load(fs3)
%
if exist('nt','var') == 0
    if isempty(storm)
        prompt = {'Order by maximum at POI (1), maximum near POI (2), lifetime maximum (3), or track number (4)?', ...
        'Track number'};
        dlg_title = 'Track Parameters';
        num_lines = 1;
        answer = inputdlg(prompt,dlg_title,num_lines);
        if isempty(answer) || isempty(answer{1})
            return
        end    
        nswitch=str2double(answer{1});
        if (strcmp(shape,'poly') || city_radius >= 2000) && nswitch == 1
            warndlg('Warning: Winds at POI not meaningful for this set; ordering by maximum near POI')
            nswitch=2;
        end                        
        nttemp=str2double(answer{2});
    else    
       nswitch=3;
       prompt={'Track Number'};
       dlg_title='Track Specification';
       num_lines=1;
       answer = inputdlg(prompt,dlg_title,num_lines);
       if isempty(answer) || isempty(answer{1})
            return
       end
       nttemp=str2double(answer{1});
    end  
    if nswitch == 1
       nt=nsortc(nttemp);
    elseif nswitch == 2
       nt=nsortp(nttemp);
    elseif nswitch == 3   
       nt=nsort(nttemp);
    else
       nt=nttemp;
    end   
end
% 
iswitch='y';
if exist('vs','var')
    vs1=vs(nt,:);
    dayk1=dayk(nt,:);
    dir2=dir1(nt,:);
end
if strcmp(shape,'circ') && city_radius < 2000
    prompt = {'Use new point of interest (POI)? (y or n)'};
    dlg_title = 'New Point of Interest';
    num_lines = 1;
    answer = inputdlg(prompt,dlg_title,num_lines);
    iswitch=answer{1};
    if isempty(answer) || isempty(answer{1})
        iswitch='n';
    end       
end
%
if strcmp(iswitch,'y')
    prompt = {'Enter POI latitude:','Enter POI Longitude:'};
    dlg_title = 'Input for POI position';
    num_lines = 1;
    answer = inputdlg(prompt,dlg_title,num_lines);
    if isempty(answer) || isempty(answer{1})
        return
    end        
    plat=str2double(answer{1});
    plong=str2double(answer{2});
    if plong < 0
        plong=plong+360;
    end    
    %
    [~,mm]=size(vstore);
    [~,jmax]=min(vstore,[],2);
    jmax=jmax-1;
    ys=repmat(yearstore(nt),[1,mm]);
    datestore=datenum(double(ys),monthstore(nt,:),daystore(nt,:), hourstore(nt,:),0,0); %#ok<DATNM>
    [vs1, dir2, dayk1] = pointseriesn(latstore(nt,:),longstore(nt,:), ...
        vstore(nt,:),rmstore1(nt,:),vsestore(nt,:),rmsestore1(nt,:), ...
        datestore,uinc(nt,:),vinc(nt,:),plat,plong,timeres);
end    
%
if exist('vs1','var') == 0 || max(vs1) == 0
    msgbox('This storm does not affect point in question')
else
%
x=dayk1;
y=wunitsfac*vs1;
y2=dir2;
[ax,h1,h2]=plotyy(x,y,x,y2);
yvmax=10.*ceil(0.1.*max(y))+10;
set(ax(1),'YLim',[0 yvmax ])
set(ax(1),'Ytick',0:10:yvmax)
set(ax(2),'YLim',[0 360])
set(ax(2),'Ytick',[0 90 180 270 360])
set(h1,'linewidth',3)
set(h2,'linestyle','none')
set(h2,'marker','.')
set(h2,'markersize',10)
set(ax(1),'fontname',gfont,'fontweight',gfontweight,'fontsize',gfontsize)
set(ax(2),'fontname',gfont,'fontweight',gfontweight,'fontsize',gfontsize) 
set(ax(1),'XLim',[x(1) x(end)])
set(ax(2),'XLim',[x(1) x(end)])
datetick(ax(1),'x','HH:MM')
datetick(ax(2),'x','HH:MM')
%
month1=datestr(x(1),'mmmm');
month2=datestr(x(end),'mmmm');
day1=datestr(x(1),'dd');
day2=datestr(x(end),'dd');
ntstring=num2str(nt);
titstring2=['Track number ' ntstring  ];
titstring3=[month1 ' ' day1 ' - ' month2 ' ' day2];
ylabl=char(strcat('Point wind speed (',wunitslabel,')'));
set(get(ax(1),'Ylabel'),'String',ylabl,'fontweight','bold','fontsize',12)
set(get(ax(2),'Ylabel'),'String','Point wind direction','fontweight','bold','fontsize',12)
xlabel(titstring3,'fontsize',12,'fontweight','bold')
title(titstring2,'fontsize',12,'fontweight','bold')
%
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 