function [vbal]= p_to_v(p)
%
% This function estimates maximum winds (m/s) given central surface
% pressure (hP), using a zero stauration PV vortex model with assumed
% constant relative humidity at the surface, from the environment inward to
% the radius of maximum winds. Note that parameters for this are set at
% beginning of this script, they are not read in from params.m. 
%
% Copyright 2009 WindRiskTech L.L.C.
%
%-------------------------------------------------------------------------
Ts=300;     % Mean surface temperature (K)
To=210;     % Mean outflow temperature (K)
lat=20;     % Latitude (degrees)
r0=700;     % Assumed outer radius (km)
rm=50;      % Radius of maximum winds (km)
p0=1008;    % Ambient surface pressure (hP)
H=0.8;      % Ambient 10 m relative humidity
a=0.7;      % Factor governing concavity of V inside r_m. Equals one for
            %  solid body rotation; less than one for concavity. 
reduc=0.84; % Factor to reduce gradient wind by to get surface wind            
%-------------------------------------------------------------------------
pi=acos(-1);
pifac=pi./180;
f=(pi./(6.*3600)).*sin(pifac.*lat);
Rd=287;
Lv=2.5e6;
Tc=Ts-273.15;
es=6.112.*exp(17.67.*Tc./(243.5+Tc));
qa=H.*0.622.*es./p0;
ep=(Ts-To)./Ts;
r0=1e3.*r0;
rm=1e3.*rm;
%
[n,m]=size(p);
%
% Precondition p
%
p=min(p,p0);
for i=1:n
    for j=1:m
        if p(i,j) < 10
            p(i,j)=p0;
        end
    end
end
%
fac1=Rd.*To-ep.*Lv*qa;
c=(2.*fac1.*log(p0./p)+0.5.*((f.*r0).^2-(f.*rm).^2))./(1+fac1.*a./(Rd.*Ts));
%
vbal=-0.25.*f.*rm+sqrt((0.25.*f.*rm).^2+c);
vbal=reduc.*vbal;
%