function [ rfac ] = outer( n,m )
% This uses the Chavas and Emanuel (2010) work to make a random draw from a
% suitable log-normal distribution to rescale the outer radius. The output
% non-dimensional factor rfac is the outer radius scale factor, which has a
% mean of 1. Scale all outer radii by this random number, and all radii of
% maximum winds by this number squared (according to Emanuel and Rotunno,
% 2011, but first power seems more reasonable). Note that parameters are
% specified here rather than in params.m.
%         Copyright WindRiskTech, L.L.C., 2012
%         Last modified August, 2015
%-------------------------------------------------------------------------
upper_bound=5;   %  Upper bound on radius multiplication factor
xm=6.15;         %  Mean log radius (km)
sd=0.3603;       %  Standard deviation of log radius (km)
%-------------------------------------------------------------------------
rng('shuffle')   %  Set seed of random number generator based on time
temp=exp(xm+sd.*randn(n,1))./423;
temp=min(temp,upper_bound);
rfac=repmat(temp,[1,m]);
%
end
