%
%  This script opens a menu window from which many different graphics
%  options may be chosen. Options for the various graphs are set at the
%  beginning of each individual graphics script. Note that some of the
%  individual graphics scripts ask for information from the user via a
%  standard MatLab dialog window.  Copyright WindRiskTeck, L.L.C., 2011
%  Last modified June, 2019
%
%------------------------------------------------------------------------
%
clear nswitch nt
params    %  Load parameters
%
% Determine if MATLAB Mapping Toolbox is present
%
v=ver;
maptoolpresent=any(strcmp('Mapping Toolbox', {v.Name}));
clear v
if strcmp(MapOverride,'y')
    maptoolpresent=0;
end   
%
gplot=2;
a=exist('temp.mat','file');
b=exist('sorted.mat','file');
if exist('tmr','var')
    delete(tmr)
end    
if a == 0 || b == 0
    msgbox('Files temp.mat and/or sorted.mat missing; run prep.m','Error','error')
    gplot=0;
else
    open params.m
    try
        close(f1)
    catch
    end
    f1=figure('visible','off');
    movegui(f1,'northeast')    
    set(f1,'visible','on')
    %
    load sorted
    load temp
    %{
    if exist('vstore','var') == 0  %  Next 7 lines added April 2015 to test for presence of correct file
        disp('Loading event set')
        load temp
    else
        vstemp=vstore;
        load temp vstore
        if vstore(end,10) ~= vstemp(end,10)
            disp('Loading event set')
            load temp
        end    
        clear vstemp
    end   
    %}
    q=max(size(vsort));
    qfilesize=q;
    datea(1)=upper(datea(1));
    tmr=timer;
    set(tmr,'startdelay',3);
    set(tmr,'timerfcn','try; delete(hms); catch err; end')
    hms=msgbox(['Loading ' num2str(q) ' tracks in ' datea]);
    start(tmr)
end
%
while gplot > 1
    gplot=menu('Graph Output','Stop','Wind speed histograms', ...
        'Return periods','POI wind return periods','POI rain return periods', ...
        'Plot track sets', 'Plot satellite map track sets', 'Plot track sets in Google Earth', ...
        'Plot individual tracks','Secondary eyewall stats', ...
        'Genesis points','Genesis density','Track density','Track statistics', ...
        'Power dissipation map','Annual cycle','Time series', ...
        'Make .png plot of current figure');
    if gplot == 1
        %
        %  Clean up temporary files
        %
        delete temp*.fig
        %
        %  Stop timers
        %
        stop(tmr)
        delete(tmr)
        clear tmr
        if exist('tmr2','var')
            stop(tmr2)
            delete(tmr2)
            clear tmr2
        end
        if exist('tmr3','var')
            stop(tmr3)
            delete(tmr3)
            clear tmr3
        end          
        if exist('tmr4','var')
            stop(tmr4)
            delete(tmr4)
            clear tmr4
        end          
        if exist('tmr5','var')
            stop(tmr5)
            delete(tmr5)
            clear tmr5
        end          
        %
        clear machine comm
        break
    elseif gplot == 2
        vhisto
        rplot=menu('Add best track histogram?','Yes','No, go back');
        if rplot == 1
            vhistobest
        end    
    elseif gplot == 3
        return_period
        rplot=menu('Add best track return period?','Yes','No, go back');
        if rplot == 1
            return_best
        end       
    elseif gplot == 4
        windpdf       
    elseif gplot == 5
        rainpdf       
    elseif gplot == 6
        if maptoolpresent
            alltrplotmt
            rplot=menu('Overlay best tracks?','Yes','No, go back');
            if rplot == 1
                allbestoverplotmt
            end    
        else
            alltrplot
            rplot=menu('Overlay best tracks?','Yes','No, go back');
            if rplot == 1
                allbestoverplot
            end    
        end
    elseif gplot == 7
        alltrmap
        rplot=menu('Overlay best tracks?','Yes','No, go back');
        if rplot == 1
            allbestovermap
        end           
    elseif gplot == 8
        alltrge
    elseif gplot == 9
        if maptoolpresent
            trplotgemt
        else
            trplotge
        end    
    elseif gplot == 10
        sestats
    elseif gplot == 11
        if maptoolpresent
            genpointsmt
            rplot=menu('Overlay best track points (in blue)?','Yes','No, go back');
            if rplot == 1
                genpointsbestmt
            end
        else    
            genpoints
            rplot=menu('Overlay best track points (in blue)?','Yes','No, go back');
            if rplot == 1
                genpointsbest
            end 
        end
    elseif gplot == 12
        if maptoolpresent
            gendensitymt 
        else
            gendensity
        end    
        rplot=menu('Plot best track genesis density?','Yes','No, go back');
        if rplot == 1
            if maptoolpresent
                gendensitybesttrackmt
            else
                gendensitybesttrack
            end   
        end         
    elseif gplot == 13
        if maptoolpresent
            trackdensitymt  
        else
            trackdensity
            %saveas(gcf,'tempsyntden');
        end    
        if exist('tmr6','var')
            stop(tmr6)
            delete(tmr6)
            clear tmr6
        end                      
        rplot=menu('Plot best track density?','Yes','No, go back');
        if rplot == 1
            if maptoolpresent
                trackdensitybestmt
            else
                trackdensitybest
            end    
        end        
    elseif gplot == 14
        trackstats    
    elseif gplot == 15
        if maptoolpresent
            pdimapmt
        else
             pdimap
             %saveas(gcf,'tempsynpdi');
        end     
        if exist('tmr6','var')
            stop(tmr6)
            delete(tmr6)
            clear tmr6
        end                                  
        rplot=menu('Plot best track power dissipation?','Yes','No, go back');
        if rplot == 1
            if maptoolpresent
                pdimapbestmt
            else
                 pdimapbest
            end
        end     
    elseif gplot == 16
        annual   
        rplot=menu('Add best track data?','Yes','No, go back');
        if rplot == 1
            annualbesterr
        end    
    elseif gplot == 17
        time_series         
    elseif gplot == 18
        try
            delete(hButton)
        catch
        end    
        prompt = {'Enter file name:'};
        dlg_title = 'File Name';
        num_lines = 1;
        answer = inputdlg(prompt,dlg_title,num_lines);
        if isempty(answer) || isempty(answer{1})
            return
        end    
        filename=answer{1};
        print('-dpng',filename)
    end
end    