function [ ] = geoback(xmin2, xmax2, ymin2, ymax2)
%
% This script reads in shapefiles used as map backgrounds by the MATLAB
% Mapping Toolbox. As supplied by WindRiskTech, it currently reads in
% coastlines, lakes, islands in lakes, national boundaries, and state 
% (or province) boundaries U.S. state boundaries. The user
% can add other backgrounds here. xmin, xmax, ymin, and ymax define the
% bounding box of the map.
%
% Note:  Xmin,xmax, ymin, ymax not currently used in this version but are
% retained in case they are needed in later versions.
%
%  Copyright WindRiskTech, L.L.C., 2013
%  Last modified April, 2017
%
res={'c','l','i','h'};  % Letter designations for resolutions of GSHHS data
params                  % Load parameters
xmin=xmin2;
xmax=xmax2;
ymin=ymin2;
ymax=ymax2;
%
lonlim=[xmin xmax];
lonlimw=wrapTo180(lonlim);
if lonlimw(1) > lonlimw(2)
    at=lonlimw;
    lonlimw(1)=at(2);
    lonlimw(2)=at(1);
    clear at
end    
latlim=[ymin ymax];
%
% Coastlines
%
file=strcat('shapefiles/GSHHS_shp/', res(cres), '/GSHHS_', res(cres),'_L1.shp');
shores=shaperead(char(file),'UseGeoCoords', true);
geoshow(shores,'FaceColor',landcolor,'EdgeColor',shorecolor,'linewidth',1)
%
% State boundaries
if strcmp(pstates,'y')
    file=strcat('shapefiles/WDBII_shp/', res(cres), '/WDBII_border_', res(cres),'_L2.shp');
    states=shaperead(char(file),'UseGeoCoords', true);
    geoshow(states,'color',stcolor,'linewidth',0.5)
end
%
if strcmp(lakes,'y') %#ok<NODEF>
    %
    % Lakes
    %
    file=strcat('shapefiles/GSHHS_shp/', res(cres), '/GSHHS_', res(cres),'_L2.shp');
    lakes=shaperead(char(file),'UseGeoCoords', true);
    geoshow(lakes,'FaceColor',oceancolor,'EdgeColor',shorecolor,'linewidth',1)
%
end
%
% Islands in lakes
%
%file=strcat('shapefiles/GSHHS_shp/', res(cres), '/GSHHS_', res(cres),'_L3.shp');
%islands=shaperead(char(file),'UseGeoCoords', true);
%geoshow(islands,'FaceColor',landcolor,'EdgeColor',shorecolor,'linewidth',1)
%
if strcmp(nations,'y') %#ok<NODEF>
    %
    % National boundaries
    %
    file=strcat('shapefiles/WDBII_shp/', res(cres), '/WDBII_border_', res(cres),'_L1.shp');
    nations=shaperead(char(file),'UseGeoCoords', true);
    geoshow(nations,'color',nacolor,'linewidth',0.5)
    %
end
%
end