%
% This script just plots the first points of each track (for which the
% winds speed > startv), filtered (if desired) to include only those 
% events whose winds speeds exceed some threshold
% Copyright 2009 WindRiskTech L.L.C.
% Last modified November, 2016
%-----------------------------------------------------------------------
%
params    %  Load parameters
%
clf
clear x y
if exist('shearstore','var') == 0
    shape='circ';
    load('temp.mat')
end
load('sorted')
[nn,m]=size(vstore);
%
if strcmp(bas,'GB')
    projection=gproject;
end    
%
nm=min(nn,nmax); % Determine number of points to plot
%
x=zeros(1,nm);
y=zeros(1,nm);
%
vmask=ceil(max(vmax-peakv,0)); % Creak mask of NaNs for storms that are insufficinetly intense
vmask=min(vmask,1);
vmask(vmask == 0)=NaN;
u=repmat(vmask,m,1);
%
xi=randperm(nn);   % Ranndomize squence of genesis points
longrand=u'.*longstore(xi,:);
latrand=u'.*latstore(xi,:);
vrand=vnet(xi,:);
vmaxrand=vmax(xi);
%
[~,jmin]=min(max((startv-vrand),0),[],2); % Determine first points at which vnet exceeds startv
%
n=0;
for k=1:nm 
   if vmaxrand(k) >= peakv  % Find first points at which vnet exceeds startv for storms with vmax > peakv
      n=n+1;
      x(n)=longrand(k,jmin(k));
      y(n)=latrand(k,jmin(k));
   end   
end
x(n+1:nm)=[]; % Truncate series of lat-long points if necessary
y(n+1:nm)=[]; 
%
if strcmp(mapmode,'auto')
    xmin=min(nonzeros(x))-dellong;
    xmax=max(x)+dellong;
    ymin=min(nonzeros(y))-dellat;
    ymax=max(y)+dellat;
else
    xmin=longmin;
    xmax=longmax;
    ymin=latmin;
    ymax=latmax;
end    
if strcmp(bas,'GB')
    xmin=0;
    xmax=360;
    ymax=ymax+dellat;
    ymin=ymin-dellat;
    ymax=min(ymax,90);
    ymin=max(ymin,-90);
end
%
axesm('MapProjection',projection,'MapLatLimit',[ymin ymax],'MapLonLimit',[xmin xmax], ...
     'frame','on','ffacecolor',oceancolor,'fontname',axisfont,'fontsize',axisfontsize, ...
     'fontweight',axisfontweight,'labelrotation','on')
delx=floor((xmax-xmin)/5);
dely=floor((ymax-ymin)/5);
gridm('mlinelocation',delx,'plinelocation',dely,'mlabellocation',delx,'plabellocation',dely,'mlabelparallel','south')
if strcmp(gridline,'none')
    gridm('off')
end
plabel('fontweight','bold'); mlabel('fontweight','bold');
axis off
%
geoback(xmin, xmax, ymin, ymax)
%
plotm(y,x,'.r','markersize',genptsize)
%
if isempty(storm)
    datea(1)=upper(datea(1));
    tit1=datea;
else
    tit1=[storm(1:2) ' ' storm(3:4) ' ' datea(1:4) ' ' datea(5:6) ' ' datea(7:8)...
    ' ' datea(9:10) ' GMT'];
end    
title(tit1,'fontsize',12,'fontweight','bold','interpreter','none')
tightmap
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 