%
% This script contours the number density of genesis points , defined as 
% the first point of each track where wind speeds exceed startv,
% filtered (if desired) to include only those events whose winds speeds  
% exceed some threshold, peakv.
% Copyright 2009 WindRiskTech L.L.C.
% Last modified April, 2024 to take advantage of "ismembertol"
%
%------------------------------------------------------------------------
%
params    %  Load parameters
%
clear latscat longscat y x z 
clf('reset')
set(gcf,'visible','off')
if exist('shearstore','var') == 0
    storm=[];
    shape='circ';
    load('temp.mat')
end
load sorted
if strcmp(bas,'GB')
    projection=gproject;
end    
[nn,m]=size(vstore);
pifac=acos(-1)./180;
%
[~,jmax]=min(vstore,[],2);
jmax=jmax-1;
%
[~,jmin]=min(max((startv-vnet),0),[],2);
longscat=zeros(1,nn);
latscat=zeros(1,nn);
freqmask=zeros(1,nn);
if exist('yearstore','var') == 0
    yeartemp=2000+zeros(1,nn);
    freqtemp=freq;
else
    yeartemp=yearstore;
    freqtemp=freqyear;
    atemp=ismember((min(yearstore):max(yearstore)),yearstore);
    atemp=cast(atemp,'like',yearstore);
    yearset=nonzeros(atemp.*(min(yearstore):max(yearstore)));
end
n=0;
for i=1:nn
   if vmax(i) >= peakv
      n=n+1; 
      longscat(n)=longstore(i,jmin(i));
      latscat(n)=latstore(i,jmin(i));
      if strcmp(bas,'MT') && longscat(n) > 300
          longscat(n)=longscat(n)-360.001;
      end    
      if strcmp(bas,'AL') && longscat(n) > 150
          longscat(n)=longscat(n)-360.001;
      end    
      [~,nyy]=ismember(yeartemp(i),yearset);
      freqmask(n)=freqtemp(nyy);
   end   
end
longscat(n+1:nn)=[];
latscat(n+1:nn)=[];
freqmask(n+1:nn)=[];
if strcmp(mapmode,'auto')
    xmin=min(nonzeros(longscat))-dellong;
    xmax=max(longscat)+dellong;
    ymin=min(nonzeros(latscat))-dellat;
    ymax=max(latscat)+dellat;
    xmin=gres*floor(xmin/gres);
    xmax=gres*ceil(xmax/gres);
    ymin=gres*floor(ymin/gres);
    ymax=gres*ceil(ymax/gres);    
else
    xmin=longmin;
    xmax=longmax;
    ymin=latmin;
    ymax=latmax;
end 
if strcmp(bas,'AL')
    %xmin=max(xmin,260);
    xmax=min(xmax,360);
    ymin=max(ymin,0);
%elseif strcmp(bas,'GB')
%    xmin=0;
%    xmax=360;
end 
%
x=xmin:gres:xmax;
y=ymin:gres:ymax;
an=max(size(y));
am=max(size(x));
z=zeros(an,am);
%
[latl,ay]=ismembertol(latscat,y,1,'DataScale',0.5*gres);
[longl,ax]=ismembertol(longscat,x,1,'DataScale',0.5*gres);
ax=max(ax,1);
ay=max(ay,1);
N=max(size(latl));
ga=freqmask.*latl.*longl./cos(pifac*latl);
for i=1:N
    z(ay(i),ax(i))=z(ay(i),ax(i))+ga(i);
end 
%
z=z./(nn*gres^2);
zsyn=z;
%
% Calculate new map limits
%
imin=1;
imax=an;
kmin=1;
kmax=am;
if strcmp(mapmode,'auto')
    xmin1=xmax;
    xmax1=xmin;
    ymin1=ymax;
    ymax1=ymin;
    kmin=am;
    kmax=1;
    imin=an;
    imax=1;
    zcrit=0.01*max(max(z));
    for j=2:an-1
        for k=2:am-1
            if z(j,k) > zcrit
                xmin1=min(xmin1,x(k));
                xmax1=max(xmax1,x(k));
                ymin1=min(ymin1,y(j));
                ymax1=max(ymax1,y(j));
                kmin=min(kmin,k);
                kmax=max(kmax,k);
                imin=min(imin,j);
                imax=max(imax,j);
            end    
        end
    end  
    xmin=xmin1;
    ymin=ymin1;
    xmax=xmax1;
    ymax=ymax1;
    if strcmp(bas,'GB')
        xmin=0;
        xmax=360;
        ymax=ymax+dellat;
        ymin=ymin-dellat;
        ymax=min(ymax,90);
        ymin=max(ymin,-90);
    end
end
%
%gh=figure('Visible','off');
axesm('MapProjection',projection,'MapLatLimit',[ymin ymax],'MapLonLimit',[xmin xmax], ...
     'frame','on','ffacecolor',oceancolor,'fontname',axisfont,'fontsize',axisfontsize, ...
     'fontweight',axisfontweight,'labelrotation','on')
delx=floor((xmax-xmin)/5);
dely=floor((ymax-ymin)/5);
gridm('mlinelocation',delx,'plinelocation',dely,'mlabellocation',delx,'plabellocation',dely,'mlabelparallel','south')
if strcmp(gridline,'none')
    gridm('off')
end
plabel('fontweight','bold'); mlabel('fontweight','bold');
axis off
R = georasterref('RasterSize', size(z(imin:imax,kmin:kmax)), ...
   'Latlim', [ymin ymax], 'Lonlim', [xmin xmax]);
cmax=(max(max(z(imin:imax,kmin:kmax))));
cint=cmax/15;
colormap(wmap)
if strcmp(wfill,'y')
    a=colormap(wmap);
    for i=1:8
        a(i,:)=oceancolor;
    end
    colormap(a)
    [C,h]=contourm(z(imin:imax,kmin:kmax),R,cint:cint:cmax,'fill','on');
    hPatch = findobj(h,'Type','patch');
    set(hPatch,'facealpha',wtrans); 
    qh=max(size(hPatch));
    set(hPatch(qh,1),'facealpha',0)
else
    [C1,h1]=contourm(z(imin:imax,kmin:kmax),R,15);
end    
%
geoback(xmin, xmax, ymin, ymax)
mlabel('south')
%
cb=colorbar;
cbIm = findobj(cb,'Type','image');
alpha(cbIm,wtrans)
set(cb,'fontweight',axisfontweight)
yvec=get(cb,'ylim');
yvec(1,1)=0.1*yvec(1,2);
set(cb,'ylim',yvec)
if isempty(storm)
    datea(1)=upper(datea(1));
    tit1=[num2str(nn) ' Tracks in ' datea];
else
    tit1=[storm(1:2) ' ' storm(3:4) ' ' datea(1:4) ' ' datea(5:6) ' ' datea(7:8)...
    ' ' datea(9:10) ' GMT'];
end    
tita='Genesis Density';
tittot={tita;tit1};
title(tittot,'fontsize',12,'fontweight','bold','interpreter','none')
set(gcf,'visible','on')
tightmap
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 