%
% This script contours the number density of genesis points , defined as 
% the first point of each track where wind speeds exceed startv,
% filtered (if desired) to include only those events whose winds speeds 
% exceed some threshold, peakv. The genesis density is dispalyed in Google
% Earth. 
% Copyright 2009 WindRiskTech L.L.C.
% Last modified April, 2024 to take advantage of "ismembertol"
%
%------------------------------------------------------------------------
trans=0.5;   % Transparency of filled contours
%------------------------------------------------------------------------
%
try
    kgendensity=kml('getempfile');
catch err
    errordlg('The free KML toolbox must be installed into MATLAB to use this script')
    return
end
%
params    %  Load parameters
%
clear latscat longscat y x z imin imax kmin kmax
if exist('shearstore','var') == 0
    storm=[];
    shape='circ';
    load('temp.mat')
end   
load sorted
[nn,m]=size(vstore);
pifac=acos(-1)./180;
%
[~,jmax]=min(vstore,[],2);
jmax=jmax-1;
%
[~,jmin]=min(max((startv-vnet),0),[],2);
longscat=zeros(1,nn);
latscat=zeros(1,nn);
freqmask=zeros(1,nn);
if exist('yearstore','var') == 0
    yeartemp=2000+zeros(1,nn);
    freqtemp=freq;
else
    yeartemp=yearstore;
    freqtemp=freqyear;
end 
n=0;
for i=1:nn
   if vmax(i) >= peakv
      n=n+1; 
      longscat(n)=longstore(i,jmin(i));
      latscat(n)=latstore(i,jmin(i));
      if (strcmp(bas,'MT')|| max(latstore(:,1)) > 50) && longscat(n) > 200
          longscat(n)=longscat(n)-360;
      end    
      freqmask(n)=freqtemp(1+yeartemp(i)-min(yeartemp));
   end   
end
longscat(n+1:nn)=[];
latscat(n+1:nn)=[];
freqmask(n+1:nn)=[];
if strcmp(mapmode,'auto')
    xmin=min(nonzeros(longscat))-dellong;
    xmax=max(longscat)+dellong;
    ymin=min(nonzeros(latscat))-dellat;
    ymax=max(latscat)+dellat;
    xmin=gres*floor(xmin/gres);
    xmax=gres*ceil(xmax/gres);
    ymin=gres*floor(ymin/gres);
    ymax=gres*ceil(ymax/gres);    
else
    xmin=longmin;
    xmax=longmax;
    ymin=latmin;
    ymax=latmax;
end 
if strcmp(bas,'AL') && max(latstore(:,1)) < 55
    xmin=max(xmin,250);
    xmax=min(xmax,360);
    ymin=max(ymin,0);
%elseif strcmp(bas,'GB')
%    xmin=0;
%    xmax=360;
end 
x=xmin:gres:xmax;
y=ymin:gres:ymax;
an=max(size(y));
am=max(size(x));
z=zeros(an,am);
%
[latl,ay]=ismembertol(latscat,y,1,'DataScale',0.5*gres);
[longl,ax]=ismembertol(longscat,x,1,'DataScale',0.5*gres);
ax=max(ax,1);
ay=max(ay,1);
N=max(size(latl));
ga=freqmask.*latl.*longl./cos(pifac*latl);  % Corrected March, 2016
for i=1:N
    z(ay(i),ax(i))=z(ay(i),ax(i))+ga(i);
end
z=z/(nn*gres^2);
zsyn=z;
%
% Calculate new map limits
%
imin=1;
imax=an;
kmin=1;
kmax=am;
if strcmp(mapmode,'auto')
    xmin1=xmax;
    xmax1=xmin;
    ymin1=ymax;
    ymax1=ymin;
    kmin=am;
    kmax=1;
    imin=an;
    imax=1;
    zcrit=0.01*max(max(z));
    for j=2:an-1
        for k=2:am-1
            if z(j,k) > zcrit
                xmin1=min(xmin1,x(k));
                xmax1=max(xmax1,x(k));
                ymin1=min(ymin1,y(j));
                ymax1=max(ymax1,y(j));
                kmin=min(kmin,k);
                kmax=max(kmax,k);
                imin=min(imin,j);
                imax=max(imax,j);
            end    
        end
    end  
    xmin=xmin1;
    ymin=ymin1;
    xmax=xmax1;
    ymax=ymax1;
end
%
cmax=(max(max(z(imin:imax,kmin:kmax))));
cint=cmax/15;
xm=repmat(x(kmin:kmax),imax-imin+1,1);
if strcmp(bas,'AL') || strcmp(bas,'EP') || strcmp(bas,'SA') || strcmp(bas,'AP')
    xm=xm-360;
end
ym=repmat(y(imin:imax),kmax-kmin+1,1);
ym=ym';
%
kgendensity.contourf(xm,ym,z(imin:imax,kmin:kmax),'numberOfLevels',ceil(cmax/cint),'transparency',trans);
kgendensity.contour(xm,ym,z(imin:imax,kmin:kmax),'numberOfLevels',ceil(cmax/cint));
%
a=jet;
kgendensity.colorbar([0,max(max(z))],a);
%
kgendensity.run
%
% Clean up
%
delete('Colorbar.png')
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 