function []=convertnc(file)
%
% This function reads in a netcdf file (with extension .nc), converts
% the stored variables to the equivalent matlab file variables, and stores
% them in tmep.mat. This function is used in prep.m, prepfilter.m, prepf.m,
% and prefilterf.m to process netcdf files instead of their matlab
% equivalents. 
%
%  Created December, 2020
%--------------------------------------------------------------------------
bas=ncread(file,'Bas');
bas=bas';
eset=ncread(file,'Eset'); %#ok<*NASGU>
freqyear=ncread(file,'Freqyear');
freqyear=freqyear';
freq=ncread(file,'Freq');
gmeth=ncread(file,'Gmeth');
gmeth={(char(gmeth))'};
model=ncread(file,'Model');
model={model'};
vcrit=ncread(file,'Vcrit');
vcrit={num2str(vcrit)};
yearstore=ncread(file,'Year');
yearstore=int32(yearstore');
monthstore=ncread(file,'Month');
daystore=ncread(file,'Day');
hourstore=ncread(file,'Hour');
latstore=ncread(file,'Latitude');
longstore=ncread(file,'Longitude');
vstore=ncread(file,'Vc');
rmstore=ncread(file,'Rm');
vsestore=ncread(file,'Vcse');
rmsestore=ncread(file,'Rmse');
pstore=ncread(file,'Pc');
shearstore=ncread(file,'Shear');
vpstore=ncread(file,'Vp');
u850store=ncread(file,'U850');
v850store=ncread(file,'V850');
T600store=ncread(file,'T600');
rhstore=ncread(file,'RH600');
%
shape='circ';
clear polyfile
try
    polyfile=ncread(file,'Polyfile');
catch ME
end
if exist('polyfile','var')
    shape={'poly'};
    x1=ncread(file,'x1');
    x2=ncread(file,'x2');
    y1=ncread(file,'y1');
    y2=ncread(file,'y2');
    A=[x1';y1';x2';y2']';
    writematrix(A,'poly.txt','delimiter',' ');
    movefile('poly.txt','poly.in')
    polyfile={(char(polyfile))'};
else
    clat=ncread(file,'Clat');
    clong=ncread(file,'Clong');
    city_radius=ncread(file,'City_radius');
end    
clear x1 x2 y1 y2 A
%
save('temp.mat')
end