%
% Plots the tracks and intensities of events from best track data sets.
% The latter must be available in matlab binary format. 
% Copyright 2009 WindRiskTech L.L.C.
% Last modified October, 2018
%
units='knots';  % Velocities in 'knots' or 'ms' (meters per second)
%------------------------------------------------------------------------
%
params    %  Load parameters
%
if longmin < 0
   longmin=longmin+360;
end
if longmax < 0
   longmax=longmax+360;
end
%
if swap == 'y'
   dummy=landcolor;
   landcolor=oceancolor;
   oceancolor=dummy;
end   
lc=tcolor;
ld=landcolor;
%
% Specify storm basin (at, ep, wp, io, sh, or bm)
%
	basin=input('Input basin (al, ep, wp, io, sh, or bm)','s');
%
basin2=basin;
if strcmp(basin,'al')
   basin2='at';
end   
if strcmp(basin,'bm')
    basin2='bom';
end    
file=strcat(trkdir,'/',basin2,'tracks');
clf
atemp=units;
clear x* y* v* u* date offset
units=atemp;
xmin=longmin;
xmax=longmax;
ymin=latmin;
ymax=latmax;
load(file)
[iq,mq]=size(daym);
year=input('Year of storm');
clear temp
temp=input('Storm number or name','s');
clear ns
ns=str2num(temp); %#ok<ST2NM>
if isempty(ns)
    for i=1:iq
        if strcmpi(temp,strtrim(stname(i,:))) && yeari(i) == year
            ns=nsi(i);
        end
    end
    if isempty(ns)
        disp('Storm not found, quitting')
        return
    end
end      
ystring=num2str(year);
ystringp=num2str(year+1);
ystringm=num2str(year-1);
nstring=num2str(ns);
months={'January','February','March','April','May','June','July','August','September','October','November','December'};
transcolor=0.5.*(landcolor+oceancolor);
colormap('default')
colormap(trackcolormap)
vcolor=colormap;
if strcmp(cbath,'n') && strcmp(ctopo,'y')
   colormap(topocolor)
else
   colormap(bathcolor)
end   
if cres == 0 && strcmp(ctopo,'y') && strcmp(tfill,'y')
   uc=colormap;
   topocolor=[landcolor;uc];
   colormap(topocolor); 
end   
n=0;
m=0;
iswitch=0;
for i=1:iq
   if year == yeari(i) && ns == nsi(i)
      clear stormname
      if min(size(stname)) == 1
          stormname=stname(i);
      else    
        stormname=strtrim(stname(i,:)); 
      end  
      x=zeros(1,mq);
      y=x;
      v=x;
      xd=x;
      yd=x;
      day=x;
      month=x;
      date=cell(mq);
      for j=1:mq
         if latm(i,j)~=0
            iswitch=1;
            n=n+1;
            x(n)=longm(i,j);
            if strcmp(basin,'at') && x(n) < 100
               x(n)=x(n)+360;
            end   
            y(n)=latm(i,j);
            v(n)=vsm(i,j);
            if hourm(i,j)<2
               m=m+1;
               xd(m)=x(n);
               yd(m)=y(n);
               day(m)=daym(i,j);
               month(m)=monthm(i,j);
               daystring=num2str(day(m));
               date(m)=cellstr(daystring);
            end      
         end
      end
      x(n+1:end)=[];
      y(n+1:end)=[];
      v(n+1:end)=[];
      xd(m+1:end)=[];
      yd(m+1:end)=[];
      day(m+1:end)=[];
      month(m+1:end)=[];
      date(m+1:end)=[];
   end
end
if iswitch == 0
   message='No data found for this storm, quitting';
   disp(message)
	return   
end
if strcmp(mapmode,'auto')
   delcritlong=15;
   delcritlat=10;
   if (max(max(x))-min(min(x)))<delcritlong
      dellong=dellong+delcritlong-max(max(x))+min(min(x));
   end   
   if (max(max(y))-min(min(y)))<delcritlat
      dellat=dellat+delcritlat-max(max(y))+min(min(y));
   end   
   xmin=min(min(x))-dellong;
   xmax=max(max(x))+dellong;
   ymin=min(min(y))-dellat;
   ymax=max(max(y))+dellat+0.5;
end   
clf('reset')
axesm('MapProjection',projection,'MapLatLimit',[ymin ymax],'MapLonLimit',[xmin xmax], ...
    'fontname',axisfont,'fontsize',axisfontsize,'fontweight',axisfontweight,'labelrotation','on', ...
    'frame','on','ffacecolor',oceancolor,'flinewidth',1,'Mlabelparallel','south')
delx=floor((xmax-xmin)/5);
dely=floor((ymax-ymin)/5);
gridm('mlinelocation',delx,'plinelocation',dely,'mlabellocation',delx,'plabellocation',dely)
if strcmp(gridline,'none')
    gridm('off')
end    
plabel('fontweight','bold'); mlabel('fontweight','bold');
axis off
%
geoback(xmin, xmax, ymin, ymax)
%
if strcmp(cspline,'y')
   a=size(x);
   b=a(1,2);
   bx=1:b;
   tint=floor(6/trackres);
   tintin=1/tint;
   bxm=1:tintin:b;
   x=spline(bx,x,bxm);
   y=spline(bx,y,bxm);
   v=spline(bx,v,bxm);
end   
a=size(x);
b=a(1,2);
if colorcoded > 0
   for i=2:b
      xt(1)=x(i-1);
      yt(1)=y(i-1);
      xt(2)=x(i);
      yt(2)=y(i);
      vta=v(i-1);
      if colorcoded == 1
         if vta < 33
            vtcolor=vcolor(1,:);
         elseif vta >= 33 && vta < 45
            vtcolor=vcolor(13,:);
         elseif vta >= 45 && vta < 54.4
            vtcolor=vcolor(30,:);
         elseif vta >= 54.4 && vta < 62.4
            vtcolor=vcolor(39,:);
         elseif vta >= 62.4 && vta < 69.5
            vtcolor=vcolor(49,:);
         else
            vtcolor=vcolor(61,:);
         end
      else   
         vtr=round(vta)-15;
         if vtr > 64
            vtr=64;
         end
         if vtr < 1
            vtr=1;
         end   
         vtcolor=vcolor(vtr,:);
      end   
      plotm(yt,xt,'color',vtcolor,'linewidth',thick)
      lc=vtcolor;
   end   
else
   plotm(y,x,lc,'linewidth',thick)
end
bd=size(xd);
bd=bd(1,2);
if dplot == 'y'
if bd > 1   
   ul=zeros(1,bd);
   vl=ul;
   for kl=2:bd-1
      ul(kl)=0.5.*(xd(kl+1)-xd(kl-1));
      vl(kl)=0.5.*(yd(kl+1)-yd(kl-1));
   end
   ul(1)=4.*(x(2)-x(1));
   vl(1)=4.*(y(2)-y(1));
	ul(bd)=4.*(x(b)-x(b-1));
	vl(bd)=4.*(y(b)-y(b-1));
else
   ul(1)=x(2)-x(1);
   vl(1)=y(2)-y(1);
end   
offset=zeros(1,bd)-0.2;
for kl=1:bd
   if day(kl)>9
      offset(kl)=-0.5;
   end
end   
vabs=0.001+sqrt(ul.^2+vl.^2);
mfactorx=(xmax-xmin)/30;
mfactory=(ymax-ymin)/30;
dx=mfactorx*textdfactor*((vl./vabs)+offset);
dy=mfactory*textdfactor*(-ul./vabs);
xdb=xd+dx;
ydb=yd+dy;
g=textm(ydb,xdb,date);
set(g,'fontname',gfont,'fontweight','bold','fontsize',textfontsize,'color',textcolor)
end
ixlab=months(month(bd));
if month(bd) > month(1)
   ixlab=strcat(months(month(1)), ' - ', months(month(bd)));
elseif month(bd) < month(1)
   if strcmp(basin,'sh')
      ixlab=['December ' ystringm ' - January'];
   else
      ixlab=['December ' ystring ' - January'];
      ystring=ystringp;
   end   
end   
if strcmp(basin,'sh') && month(1) > 6 && month(1) <= month(bd)
   ystring=ystringm;
end
ixlab=char(ixlab);
titstring=[char(stormname) ',  ' ixlab ' ' ystring];
atit=char(stormname);
if max(size(atit))~= 8
     if isempty(atit) || (strcmp(atit(1),'N') && strcmp(atit(2),'O'))
         titstring=['Storm number ' nstring ',  ' ixlab ' ' ystring];
     end    
end  
ua=x(a(1,2))-x(a(1,2)-1);
va=y(a(1,2))-y(a(1,2)-1);
uabs=sqrt(ua^2+va^2)+0.001;
scalef=sqrt(mfactorx^2+mfactory^2);
ua=2*ua*scalef/uabs;
va=2*va*scalef/uabs;
xq=x(a(1,2));
yq=y(a(1,2));
g1=quiverm(yq,xq,0.8*va,0.8*ua,0);
set(g1,'linewidth',thick)
set(g1,'color',lc)
if strcmp(cplot,'y')
   plotm(yd,xd,'.','color',ccol,'MarkerSize',csize)    
end   
title(titstring,'fontsize',axisfontsize,'fontweight','bold')
if colorcoded > 0 && strcmp(cbar,'y')
   if colorcoded == 1
      ucolor=[vcolor(1,:);vcolor(13,:);vcolor(30,:);vcolor(39,:);vcolor(49,:);vcolor(61,:)];
      aa=0:6;
      bb=1/6;
      tstring='Category';
   else
      ucolor=vcolor;
      if strcmp(units,'ms')
          aa=20:10:80;
          bb=1/6;
          tstring='m/s';
      else
          aa=40:20:160;
          bb=1/6;
          tstring='knots';
      end
   end
   colormap(ucolor);
   rts=colorbar('horiz');
   posit=get(gca,'position');
   rr=get(rts,'position');
   xl=get(gca,'xlim');
   yl=get(gca,'ylim');
   yfrac=(yl(2)-yl(1))./(xl(2)-xl(1));
   rr2=rr;
   rr2(3)=0.75*rr(3);
   rr2(3)=max(rr2(3),0.4);
   rr2(1)=posit(1)+0.5*posit(3)-0.5*rr2(3);
   rr2(2)=0.5.*rr2(2);
   rr2(4)=0.015;
   %
   set(rts,'position',rr2)
   set(rts,'ticklength',0)
   set(rts,'xaxislocation','bottom')
   set(rts,'fontname',axisfont,'fontweight','bold')
   set(rts,'xtick',0:bb:1,'xticklabel',aa)
   set(gca,'position',posit)
   set(get(rts,'xlabel'),'String',tstring,'fontweight','bold')
end
tightmap
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end