%
% Calculate and graph the number of storms per month. 
% Copyright 2009 WindRiskTech L.L.C.
% Last modified November, 2018
%-------------------------------------------------------------------------
%
params    %  Load parameters
%
clf('reset')
clear x y y2 y3 y4
if exist('shearstore','var') == 0
    shape='circ';
    storm=[];
    load('temp.mat')
end
load('sorted')
basn=[];
[m,n]=size(vstore);
%
[~,jmin]=min(max((startv-vnet),0),[],2);
y=zeros(1,12);
x=1:12;
monthtemp=zeros(1,m);
for i=1:m
    monthtemp(i)=monthstore(i,jmin(i));
end    
clear vmask
vmask(1,:)=ceil(min(max(vmax-vcritann,0),1));
atemp=ismember((min(yearstore):max(yearstore)),yearstore);
atemp=cast(atemp,'like',yearstore);
%atemp=cast(atemp,"double");
yearset=nonzeros(atemp.*(min(yearstore):max(yearstore)));
[~,nyy]=ismember(yearstore,yearset);
freqstorm=vmask.*freqyear(nyy);
for k=1:12
   y(k)=sum(freqstorm.*ismember(monthtemp,k));
end
msyn=sum(vmask);
y=y./m;
h=plot(x,y,'b','linewidth',2);
set(gca,'fontname',gfont,'fontsize',gfontsize,'fontweight',gfontweight)
set(gca,'xlim',[0.5 12.5])
xlabel('Month','fontweight','bold')
ylabel('Number of storms per month','fontweight','bold')
if isempty(storm)
    datea(1)=upper(datea(1));
    tit1=datea;
else
    tit1=[storm(1:2) ' ' storm(3:4) ' ' datea(1:4) ' ' datea(5:6) ' ' datea(7:8)...
    ' ' datea(9:10) ' GMT'];
end    
title(tit1,'fontsize',12,'fontweight','bold','interpreter','none')
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end