%
% This script creates maps of multiple tropical cyclone tracks, ordered by
% maximum lifetime intensity, by maximum wind speed at a point of interest
% or the intersection points of tracks with a specified set of line
% segments, or randomly. "Prep" must be run before this can be used, 
% and either the matlab mapping toolbox or the m_map routines must be installed. 
% November 2008
% Copyright 2009 WindRiskTech L.L.C.
% Last modified August, 2015
%-------------------------------------------------------------------------
%
params    %  Load parameters
%
clf('reset')
%
if exist('shearstore','var') == 0
    shape='circ';
    load('temp.mat')
end
fs3='sorted';
load(fs3)
[nsize,jsize]=size(latstore);
%
if strcmp(bas,'GB')
       projection=gproject;
end
if strcmp(bas,'MT') || strcmp(bas,'AL') || strcmp(bas,'SA')%  For Mediterranean and Atlantic basins, rectify longitudes
    longstore = wrapTo180(longstore);
end   
%
if isempty(storm)
    prompt = {'Order by maximum at POI (1), maximum near POI (2), lifetime maximum (3), or random (4)?', ...
        'Starting track number ', ...
        'Ending track number (hit return to use whole set)'};
    dlg_title = 'Track Parameters';
    num_lines = 1;
    answer = inputdlg(prompt,dlg_title,num_lines);
    if isempty(answer) || isempty(answer{1})
        return
    end    
    nswitch=str2double(answer{1});
    if (strcmp(shape,'poly') || city_radius >= 2000) && nswitch == 1
        warndlg('Warning: Winds at POI not meaningful for this set; ordering by maximum near POI')
        nswitch=2;
    end    
    nt=str2double(answer{2});
    net=str2double(answer{3});
else    
   nswitch=3;
end   
%
if isnan(net)
    net=nsize;
end    
%
[~,jmax]=min(vstore,[],2);
jmax(vstore(:,end)~=0)=jsize;
jmax=jmax-1;
%
hold off
%
col=cell(1,2000);
col(1)=cellstr('r');
col(2)=cellstr('b');
col(3)=cellstr('g');
col(4)=cellstr('c');
col(5)=cellstr('m');
%
for i=6:2000
   col(i)=col(i-5);
end   
colormap(trackcolormap);
vcolor=colormap;
%
ymin=90;
ymax=-90;
xmin=360;
xmax=-360;
rng('shuffle')   %  Set seed of random number generator based on time
%
% Determine ordering of tracks
%
nt3=zeros(1,net);
for ntt=nt:net
   if nswitch == 3
   %
   % Ordered by most intense over lifetime
   %
   nt3(ntt)=nsort(ntt);
   %
   elseif nswitch == 2
   %
   % Ordered by most intense near POI
   %
   nt3(ntt)=nsortp(ntt);
   %
   elseif nswitch == 1
   %
   % Ordered by most intense at POI
   %
   nt3(ntt)=nsortc(ntt);
   %
   elseif nswitch == 4
   %
   % Randomly ordered
   %
   nt3(ntt)=1+floor((max(nsort)-1).*rand);
   %
   end
%
   for i=1:jsize
      if latstore(nt3(ntt),i) ~= 0
         y2=latstore(nt3(ntt),i);
         x2=longstore(nt3(ntt),i);
         xmin=min(xmin,x2);
         xmax=max(xmax,x2);
         ymin=min(ymin,y2);
         ymax=max(ymax,y2);
      end
   end  
end   
%
ymax=ymax+1.5*dellat;
ymin=ymin-dellat;
ymax=min(ymax,90);
ymin=max(ymin,-90);
xmax=xmax+dellong;
xmin=xmin-dellong;
if strcmp(bas,'GB') 
    xmax=min(xmax,360);
    xmin=max(xmin,0);
end
%
%if strcmp(bas,'GB')
%    xmin=max(xmin,-179);
%    xmax=min(xmax,179);
%end    
%
if strcmp(mapmode,'manu')
    xmin=longmin;
    xmax=longmax;
    ymin=latmin;
    ymax=latmax;
end
%
mfactorx=(xmax-xmin)/30;
mfactory=(ymax-ymin)/30;
%
%  Specify map projection 
%
axesm('MapProjection',projection,'MapLatLimit',[ymin ymax],'MapLonLimit',[xmin xmax], ...
    'fontname',axisfont,'fontsize',axisfontsize,'fontweight',axisfontweight,'labelrotation','on', ...
    'frame','on','ffacecolor',oceancolor,'flinewidth',1)
delx=floor((xmax-xmin)/5);
dely=floor((ymax-ymin)/5);
gridm('mlinelocation',delx,'plinelocation',dely,'mlabellocation',delx,'plabellocation',dely)
if strcmp(gridline,'none')
    gridm('off')
end
plabel('fontweight','bold'); mlabel('fontweight','bold');
axis off
%
geoback(xmin, xmax, ymin, ymax)
mlabel('south')
tightmap
%
mmax=0;   
%
vcmax=0;vcmin=300;
for ntt=net:-1:nt
    if nswitch == 2
        if vmax(nt3(ntt)) < lpthresh
            break
        end
    end    
   nt3s=num2str(nt3(ntt));
   ntcolor=ntt-nt+1;
   clear x y s
   % 
   y=latstore(nt3(ntt),1:jmax(nt3(ntt)));
   x=longstore(nt3(ntt),1:jmax(nt3(ntt)));
   z=zeros(size(x));
   v=wunitsfac*vnet(nt3(ntt),1:jmax(nt3(ntt)));
   vcmax=max(vcmax,max(v));
   vcmin=min(vcmin,min(nonzeros(v)));
   %
   % Plot tracks
   %
   if colorscheme == 0
        h=scatterm(y,x,5,tcolor,'filled');
   else
        h=scatterm(y,x,5,v,'filled');
        %surfacem([y;y],[x;x],[z;z],[v;v]/max(v), ...
        %'facecol','no',...
        %'edgecol','interp',...
        %'linew',2);
        %h = patchm(y,x,v,'linewidth',2);
        %set(h, 'edgecolor', 'interp','facecolor','no');
   end  
%
% Put arrowheads on tracks
%
   mmax=jmax(nt3(ntt));
   ua=x(mmax)-x(mmax-1);
   va=y(mmax)-y(mmax-1);
   xq=x(mmax-1);
   yq=y(mmax-1);
   scale=afactor/sqrt(ua^2+va^2);
   ua=ua*scale;
   va=va*scale;
   g1=quiverm(yq,xq,0.8*va,0.8*ua,0);
   set(g1,'linestyle',':','linewidth',2)
   xb=x(1);
   yb=y(1);
   if strcmp(startdot,'y')
        plotm(yb,xb,'.','color','r','MarkerSize',12) 
   end     
   if strcmp(textlabel,'y')
       g=textm(yb,xb,nt3s);
       set(g,'fontname','arial','fontweight','bold','fontsize',9,'color',tcolor)
   end
end
if colorscheme > 0
    cb=colorbar;
    set(cb,'fontweight','bold')
    set(get(cb,'ylabel'),'String',wunitslabel,'fontweight','bold','rotation',0,'horizontalalignment','left');
end    
if isempty(storm)
    datea(1)=upper(datea(1));
    tit1=datea;
else
    tit1=[storm(1:2) storm(3:4) ' ' datea(1:4) ' ' datea(5:6) ' ' datea(7:8)...
    ' ' datea(9:10) ' GMT'];
end    
title(tit1,'fontsize',12,'fontweight','bold','interpreter','none')
%
colormap(trackcolormap)
load temp longstore
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 