function [u,v] = Pointwind(latstore,longstore,vstore,rmstore,vsestore, ...
    rmsestore,u850store,v850store,lat,long)
%
%  This function accepts inputs of storm latitude and longitude (degrees),
%  peak wing (knots), radius of peak winds (km), 850 hPa background wind
%  components (m/s), and the latitude and longitude of a fixed point
%  (degrees) and returns the x and y components of wind (knots) at the
%  fixed point. The storm vectors can be one-dimensional, containing all the
%  points of a single track, or two-dimensional, containing the two or more
%  tracks, with the first index representing the track number. (Note they
%  cannot be single points along the track.)
%
%  Copyright WindRiskTech, L.L.C., March, 2014
%  Last modified October 2014
%
params   %  Load parameters
pifac=acos(-1)/180;
%
if long < 0
    long=long+360;
end      
%
%  Calculate translation velocity and wind speed increments
%
[~,~,uinc,vinc ] = utransfull(latstore,longstore,vstore,u850store,v850store);    
%
% Find distance from point in question to storm center
%
dy=lat-latstore;
dx=cos(pifac*latstore).*(long-longstore);
r=sqrt(dx.^2+dy.^2);  % Distance of fixed point from storm center, in km
%
[ V ] = windprofilem( vstore, rmstore, vsestore, rmsestore, 60.*1.852.*r, ...
    wprofile);   %  This calculates the azimuthal wind at fixed point 
                 %  using canonical wind profiles
%
V=V.*latstore./(abs(latstore)+1e-8);  % Reverse sign for southern hemisphere
%
v=vinc+V.*dx./max(r,0.5);
u=uinc-V.*dy./max(r,0.5);
%
end