%
%  This script reads shape files from one or more sources, uses m_shaperead
%  to read them, and concatentates them into separate name and boundary
%  files for use by other scripts, notably m_states.m
%
%--------------------------------------------------------------------
%
% List of shape file names. All of these should have corresponding
%   .dbf, .shp, and .shx extensions.
%
file(1).name='50m_admin_0_countries';
file(2).name='50m_admin_1_states_provinces_shp';
%--------------------------------------------------------------------
q=max(size(file));
M=m_shaperead(file(1).name);
country=M.NAME;
u=M.ncst;
for i=2:q
    M=m_shaperead(file(i).name);
    ct=M.NAME;
    dt=M.ncst;
    country=[country;ct];
    u=[u;dt];
end    
save pboundaries country u

    
   