function [  ] = m_states(xmin, xmax, ymin, ymax, varargin)
%  This function is used in conjunction with the m_map routines to plot
%    political boundaries on maps. The political boundaries are stored in
%    the matfile pboundaries, generated by the script statesgen.m. 
%    The inputs xmin, xmax, ymin, and ymax are the minimum and maximum
%    map longitudes and latitudes in the calling map program. The variable
%    argument list may contain the same properties as in line.m.
%
%------------------------------------------------------------------------- 
load pboundaries       % Mat file containing all political boundaries
q=max(size(country));
%
% Cycle through nations and states
%
for i=1:q,
    clear a
    a=country(i);
    x=u{i};
    clear bndry_lon bndry_lat namef
    bndry_lon=transpose(x(:,1));
    qn=max(size(bndry_lon));
    if max(bndry_lon) < max((xmax-360),0)
        bndry_lon=bndry_lon+360;
    end
    bndry_lat=transpose(x(:,2));
    %
    % Skip boundaries that lie entirely outside map domain
    %
    aplot=1;
    if min(bndry_lon) > xmax | max(bndry_lon) < xmin ...
            | min(bndry_lat) > ymax | max(bndry_lat) < ymin
        aplot=0;
    end       
    if aplot > 0
        m_line(bndry_lon,bndry_lat,'tag','m_plotbndry',varargin{:});
    end
end    
