%%
% This graph displays return periods, either the annual exceedence inverse
% probability or as the inverse probability per wind speed bin, according
% to the parameter _histf_ as set in the _params.m_ file. The synthetic
% tracks are compared to historical tracks. The velocity used depends on
% the value of _htype_ in the _params_ file and the type of event set. The
% default value of 2 gives the maximum winds of each event within the
% specified distance of the point of interest, for a circular filter, or at
% the point that events cross over line segments for poly filters. (The
% "maximum winds" in this case are the maximum winds anywhere in the storm
% at the point it crosses one of the line segments in poly.)  The value 1
% gives the lifetime maximum wind for all events in the set, and the value
% of 3 gives the maximum wind at the point of interest when a circular
% filter is used. (For poly filters, choice 3 is the same as choice 2).
% Under the entry _Histograms and return period plots_ in the _params_ file,
% other aspects of the graph and data can be set including the range of
% best-track years to use, the range of wind speeds to consider, and the
% width of the wind speed bins.
%
% If the parameter _ebar_ is set to _'y'_ in the _params_ file, this plot will
% also display, in shading, an estimate of the best-track sampling error. 
% This estimate has been created by, for each wind speed bin, estimating
% the expected number of best-track events in that bin by multiplying the
% synthetic track frequency by the number of years in the best track data.
% Once this central estimate is obtained, the integer value of the 5th and
% 95th percentiles are obtained from a Poisson distribution with that
% central frequency estimate. The shading is between these bounds. In
% principle, 90% of the best track frequencies should lie within the
% shading if they represent the same distribution as the synthetic tracks.
