function [filtyears] = yearsets(setname)
% This function defines various sets of years used in year filter. The
% choices include:
    % None:     Use all years in event set (no filtering)
    % Nina:     La Niña years going back to 1950
    % EPnino:   Eastern Pacific El Niño years going back to 1951  
    % CPnino:   Central Pacific El Niño years going back to 1953
    % ONInina:  Oceanic Niño Index (ONI) La Niña years
    % ONInino:  Oceanic Niño Index (ONI) El Niño years
    %
% Some specialized sets that may not be of general interest:
    %
    % Ausnina:  La Niña years used by a researcher for Australia
    % Ausnino   El Niño years used by a researcher for Australia
    % ITCZmaxsouth: Years ITCZ is centered south of normal (Australia)
    % ITCZmaxnorth: Years ITCZ is centered north of normal (Australia)
    % ITCZSBsouth:  Years southern boundary of ITCZ is centered south of normal (Australia)
    % ITCZSBnorth:  Years southern boundary of ITCZ is centered north of normal (Australia)
    % Millennium_north:  Years southern boundary of ITCZ is centered north of normal (Australia)
    % Millennium_south:  Years southern boundary of ITCZ is centered south of normal (Australia)
% If setname is a numeric vector, then routine returns this vector as filtyears    
%
% Copyright WindRiskTech, LLC
% Last modified December, 2020
%------------------------------------------------------------------------------------------
if strcmpi(setname,'none')
    filtyears=0;
elseif strcmpi(setname,'nina')    
    filtyears=[1950 1952 1954 1955 1956 1959 1960 1961 1962 1964 1966 1967 1970 1971 1973 1974 1975 1978 1979 1980 1981 1983 1984 1988 1995 1998 1999 2005 2007]; 
elseif strcmpi(setname,'epnino')    
    filtyears=[1951 1969 1972 1976 1982 1986 1991 1997 2006];
elseif strcmpi(setname,'cpnino')  
    filtyears=[1953 1957 1958 1963 1965 1968 1977 1987 1994 2002 2004 2009]; 
elseif strcmpi(setname,'oninina')   
    filtyears=[1954,1955,1956,1964,1970,1971,1973,1975,1988,1995,1998,1999,2000,2007,2010,2011,2016,2020];
    %filtyears=[1956 1971 1974 1976 1989 1999 2008 2011];
elseif strcmpi(setname,'oninino')  
    filtyears=[1951,1953,1957,1963,1965,1968,1969,1972,1982,1987,1991,1997,2002,2004,2009,2015];   
    %filtyears=[1958 1964 1965 1973 1982 1987 1988 1992 1998 2003 2009 2016]; 
elseif strcmpi(setname,'ausnina')    
    filtyears=[1980,1983:1985,1988,1995:1996,1998,1999:2000,2005,2007:2008,2010,2011,2017]; 
elseif strcmpi(setname,'ausnino')    
    filtyears=[1982,1986:1987,1991,1994,1997,2002,2004,2006,2009,2014,2015];
elseif strcmpi(setname,'ITCZmaxsouth')
    filtyears=[1983,1993,1996,1999,2007,2008,2010,2011]; 
elseif strcmpi(setname,'ITCZmaxnorth')    
    filtyears=[1984,1985,1987,1988,1992,1994,2006,2015];
elseif strcmpi(setname,'ITCZSBsouth')    
    filtyears=[1982,1990,1996,1999,2008,2010,2011]; 
elseif strcmpi(setname,'ITCZSBnorth')      
    filtyears=[1985,1987,1992,1993,1995,2001,2004];
elseif strcmpi(setname,'Millennium_north')      
    load millnorth ITCZ_north
    filtyears=ITCZ_north;
elseif strcmpi(setname,'Millennium_south')      
    load millsouth ITCZ_south
    filtyears=ITCZ_south;    
else
    filtyears=setname;
end
%
end
