function [x,y,maxwind] = windswathx(nt)
%
%  This function calculates the distribution of maximum point wind speed,
%  in knots, for a single storm.
%
%  nt is the track number of the storm
%
%  x and y are vectors containing the longitudes and latitudes of the grid
%
%  maxwind is the storm maximum wind speed (knots) at each point on the
%  grid
%
%  The grid resolution and dimensions can be set automatically or
%  specified in the swath map section of params.m.

%  Note:  If discontinuities appear in the result, increase the parameter
%  "timelength" in params.m.
%
%       January, 2009
%       Copyright 2009 WindRiskTech L.L.C.
%
%  Last modified May, 2019
%------------------------------------------------------------------------
%
params    %  Load parameters
%
load temp vstore vsestore latstore longstore rmstore rmsestore uinc vinc
load temp shape city_radius clat clong 
if strcmp(shape,'poly')
    load temp polytype
end    
load sorted %#ok<LOAD>
%
% Scale storm dimensions
%
rmstore1=rmstore.*magfac;
rmsestore1=rmsestore.*magfac;
%  
% Randomize radii of maximum wind
%
if strcmp(randfac,'y')
    [nrm,mrm]=size(rmstore);
    rfac=outer(nrm,mrm);
    rmstore1=rmstore1.*rfac;
    rmsestore1=rmsestore1.*rfac;
end
%
[~,q]=min(abs(latstore(nt,:)));
q=q-1;
utd(1,:)=transpose(nonzeros(uinc(nt,:)));
vtd(1,:)=transpose(nonzeros(vinc(nt,:)));
lat(1,:)=transpose(nonzeros(latstore(nt,:)));
long(1,:)=transpose(nonzeros(longstore(nt,:)));
v(1,:)=transpose(nonzeros(vstore(nt,:)));
qv=max(size(v));
rm(1,:)=transpose(nonzeros(rmstore1(nt,:)));
vse(1,:)=vsestore(nt,1:qv);
rmse(1,:)=rmsestore1(nt,1:qv);
for i=1:q
    if long(1) > 200 && long (i) < 50
        long(i)=long(i)+360;
    end
end  
%
if strcmp(bound,'auto')
    if (strcmp(shape,'circ') && city_radius > 2000) || (strcmp(shape,'poly') && strcmp(polytype,'closed'))
        bxmin=min(nonzeros(long))-deltax;
        bxmax=max(nonzeros(long))+deltax;
        bymin=min(nonzeros(lat))-deltay;
        bymax=max(nonzeros(lat))+deltay;
    else    
        if strcmp(bound,'auto')
            if strcmp(shape,'circ')
                bxmin=clong-deltax;
                bxmax=clong+deltax;
                bymin=clat-deltay;
                bymax=clat+deltay;
            else
                [~,xsize]=size(xint);
                vtemp=0;
                ixmax=1; 
                for ix=1:xsize
                    if kint(nt,ix) > 0 && vnet(nt,kint(nt,ix)) > vtemp
                        vtemp=vnet(nt,kint(nt,ix));
                        ixmax=ix;
                    end
                end    
                xm=xint(nt,ixmax);
                ym=yint(nt,ixmax);
                bxmin=xm-deltax;
                bxmin=max(bxmin,0);
                bxmax=xm+deltax;
                bymin=ym-deltay;
                bymax=ym+deltay;
            end
        end  
    end
end
%
x=bxmin:dellatlongs:bxmax;
y=bymin:dellatlongs:bymax;
sx=max(size(x));
sy=max(size(y));
if sx == sy
    x(sx+1)=bxmax+dellatlongs;
    sx=sx+1;
end    
maxwind=zeros(sx,sy);
[vs1, ~] = pointshortn(lat,long,v,rm,vse,rmse,utd,vtd,y,x,timeres);
maxwind(:,:)=max(vs1(1,:,:,:),[],2);   
maxwind=smoothb(maxwind,sx-1,2,sy-1);
maxwind=transpose(maxwind);
%maxwind=maxwind.*1.15;  % Conversion to MPH
%
end

