function [ut,vt,uinc,vinc ] = utransfull( latstore,longstore,varargin )
%
%  Calculates translation speed and corrections to circular wind speed
%  In addition to latstore and longstore, input (in order) vstore,
%  u850store, and v850store, if available.
%  Copyright WindRiskTech, L.L.C., 2011
%  Last modified May, 2014
%-------------------------------------------------------------------------
if nargin < 5 && nargin > 2
    disp('Need vstore, u850store, and v850store (in that order)')
    return
end    
if nargin > 2
    vstore=(varargin{1});
    u850store=(varargin{2});
    v850store=(varargin{3});
end
%
%  Calculate translation velocity
%
[ut,vt,~] = utrans(latstore,longstore);
%
%  Add latitude-dependent fraction of translation speed to circular wind
%
transfunc=transfunction(latstore);
uinc=transfunc.*ut;
vinc=transfunc.*vt;
%
%  If environmental 850 hPa wind available, add baroclinic factor to wind
%  speed
%
if exist('u850store','var')
    udrift=-0.9*3600/1852;
    vdrift=1.4.*3600./1852;
    vdrift=vdrift.*latstore./(abs(latstore)+1e-8);
    uinc=uinc+0.5.*(ut-udrift-u850store).*(vstore./15);    %  These factors changed from 0.25 to 0.5, May, 2014
    vinc=vinc+0.5.*(vt-vdrift-v850store).*(vstore./15);
end  
%
%  Do not allow wind speed increments to exceeed circular gradient wind
%      Added August, 2012
%
if nargin > 2
    ufrac=vstore./(0.1+abs(uinc));
    ufrac=min(ufrac,1);
    uinc=uinc.*ufrac;
    vfrac=vstore./(0.1+abs(vinc));
    vfrac=min(vfrac,1);
    vinc=vinc.*vfrac;
end
%
end