function [ut,vt,jmax] = utransbest(latstore,longstore,monthstore,...
    daystore,hourstore)
%
%  Read in track file, calculate translation speeds (knots) and smooth
%               K. Emanuel 11/8/2008
%      Copyright 2008 WindRiskTech L.L.C.
%  Last modified May, 2020 to re-do Greenwich crossings
% ------------------------------------------------------------------
%  Smoothing factor
%
smfac=0.4;
%
%-------------------------------------------------------------------
pifac=acos(-1)/180;
dfac=60.*1.852;
dtfac=1./(24.*1.852);
netfac=dtfac.*dfac;
%
[nn,m]=size(latstore);
%
ut=zeros(nn,m);
vt=zeros(nn,m);
jmax=zeros(1,nn);
for n=1:nn
%
   lat=latstore(n,:);
   [~,jm]=min(abs(lat));
   jm=jm-1;
   jm=max(jm,2);
   jmax(n)=jm;
   long=longstore(n,:);
   delday=zeros(1,jm);
   delday(1,1)=0.5;
   delday(1,jm)=0.5;
   for j=2:jm-1
       V2=[2008 monthstore(n,j+1) daystore(n,j+1) hourstore(n,j+1) 0 0];
       V1=[2008 monthstore(n,j-1) daystore(n,j-1) hourstore(n,j-1) 0 0];
       delday(j)=datenum(V2)-datenum(V1);
       if delday(j) < 0
           delday(j)=delday(j)+366;
       end    
       delday(j)=max(delday(j),0.1);
   end
   deldayinv=1./delday(2:jm-1);
   longdif=long(3:jm)-long(1:jm-2);
   for j=1:jm-2
       if longdif(j) < -300
           longdif(j)=longdif(j)+360;
       elseif longdif(j) > 300
           longdif(j)=longdif(j)-360;
       end
   end 
   ut(n,2:jm-1)=netfac.*deldayinv.*cos(pifac.*lat(2:jm-1)).*longdif;
   vt(n,2:jm-1)=netfac.*deldayinv.*(latstore(n,3:jm)-...
       latstore(n,1:jm-2));
   j2=min(3,jm);
   j3=max(jm-2,1);
   ut(n,1)=2.*ut(n,2)-ut(n,j2);
   ut(n,jm)=2.*ut(n,jm-1)-ut(n,j3);
   vt(n,1)=2.*vt(n,2)-vt(n,j2);
   vt(n,jm)=2.*vt(n,jm-1)-vt(n,j3);
   if jm < 3
       ut(n,1:jm)=0;
       vt(n,1:jm)=0;
   end    
   %
   %  Smooth translation velocity
   %
   vt(n,2:jm-1)=vt(n,2:jm-1)+smfac.*(vt(n,1:jm-2)+vt(n,3:jm)-2.*vt(n,2:jm-1));
   ut(n,2:jm-1)=ut(n,2:jm-1)+smfac.*(ut(n,1:jm-2)+ut(n,3:jm)-2.*ut(n,2:jm-1));
end     