%
% This script contours the number density of all 6 hour best track points,  
% filtered (if desired) to include only those events whose winds speeds 
% exceed some threshold, peakv. It requires installation of the
% "m_map" routines. Tracks interpolated to 2 hours. 
% Copyright 2009 WindRiskTech L.L.C.
% Last modified April, 2024 to take advantage of "ismembertol"
%------------------------------------------------------------------------
%
if exist('shape','var') == 0 || exist('xmax','var') == 0
    f=msgbox('Need to run trackdensity before running this script');
    return
end
%
params    %  Load parameters
%   
figure
clear latscat longscat z 
%
pi=acos(-1);
pifac=pi./180;
%
bestproc   %  Process best tracks
%
yearbeg=min(bestyears);
yearend=max(bestyears);
%
if strcmp(bas,'GB')
    projection=gproject;
end 
%
[n,m]=size(vbest);
%
latmask=min(ceil(abs(latbest)),1);
longbest=min(longbest,359.99);
if strcmp(bas,'MT')         %  For Mediterranean and Atlantic basins, rectify longitudes
    longbest = wrapTo180(longbest);
end 
yearsize=max(size(bestyears));
%
an=max(size(y));
am=max(size(x));
z2=zeros(an,am);
%
clear vmax2
vmax2(1,:)=ceil(min(max(vmaxb-peakv,0),1));
vmax3=repmat(vmax2',[1,m]);
dum=nonzeros(vmax3'.*latbest');
[latl,ay]=ismembertol(dum,y,1,'DataScale',0.5*mres);
dum=nonzeros(vmax3'.*longbest');
[longl,ax]=ismembertol(dum,x,1,'DataScale',0.5*mres);
clear dum
vl=ceil(min(max((nonzeros(vmax3.*latmask.*(vbest+0.01))-minv),0),1));
%if max(size(vl)) ~= max (size(latr))   %    Skip minv calculation when velocity data is missing
%    vl=1;
%end
%
ax=max(ax,1);
ay=max(ay,1);
%
N=max(size(latl));
den=vl.*latl.*longl./cos(pifac*latl);
%
for i=2:N
    if ay(i) ~= ay(i-1) || ax(i) ~= ax(i-1)
        z2(ay(i),ax(i))=z2(ay(i),ax(i))+den(i);
    end    
end 
z2=z2./(yearsize*mresbest^2);
%z=smooth2(z);
%
gh=figure('Visible','off');
axesm('MapProjection',projection,'MapLatLimit',[ymin ymax],'MapLonLimit',[xmin xmax], ...
     'frame','on','ffacecolor',oceancolor,'fontname',axisfont,'fontsize',axisfontsize, ...
     'fontweight',axisfontweight,'labelrotation','on')
delx=floor((xmax-xmin)/5);
dely=floor((ymax-ymin)/5);
gridm('mlinelocation',delx,'plinelocation',dely,'mlabellocation',delx,'plabellocation',dely,'mlabelparallel','south')
if strcmp(gridline,'none')
    gridm('off')
end
plabel('fontweight','bold'); mlabel('fontweight','bold');
axis off
R = georasterref('RasterSize', size(z2(imin:imax,kmin:kmax)), ...
   'Latlim', [ymin ymax], 'Lonlim', [xmin xmax]);
%
geoback(xmin, xmax, ymin, ymax)
mlabel('south')
%
colormap(wmap)
if strcmp(wfill,'y')
    [C,h]=contourm(z2(imin:imax,kmin:kmax),R,15,'fill','on');
    hPatch = findobj(h,'Type','patch');
    set(hPatch,'facealpha',wtrans); 
    qh=max(size(hPatch));
    set(hPatch(qh,1),'facealpha',0)
else
    [C1,h1]=contourm(z2(imin:imax,kmin:kmax),R,15,'linewidth',1);
end
%
set(gh,'visible','on')
%
cb=colorbar;
set(cb,'fontname',axisfont,'fontweight','bold')
yvec=get(cb,'ylim');
yvec(1,1)=0.1*yvec(1,2);
set(cb,'ylim',yvec)
cbIm = findobj(cb,'Type','image');
alpha(cbIm,wtrans)
titbest=['Best track density from ' num2str(yearbeg) ' to ' num2str(yearend)];
title(titbest,'fontsize',12,'fontweight','bold','interpreter','none')
tightmap
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    delete(hButton)
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 