%
% This script contours the number density of all 2 hour track points,  
% filtered (if desired) to include only those events whose winds speeds 
% exceed some threshold, peakv. It requires installation of the
% "m_map" routines.
% Copyright 2009 WindRiskTech L.L.C.
% Last modified August, 2015
%------------------------------------------------------------------------
%
params    %  Load parameters
%
clf('reset')
clear latscat longscat y x z vmax2
if exist('shearstore','var') == 0
    shape='circ';
    load('temp.mat')
end
load('sorted')
[nn,m]=size(vstore);
if strcmp(bas,'GB')
    projection=gproject;
end    
if exist('yearstore','var') == 0
    yearstore=2000+zeros(1,nn);
    freqyear=freq;
end
qy=length(freqyear);
%
pi=acos(-1);
pifac=pi/180;
%
latmask=min(ceil(abs(latstore)),1);
%{
if strcmp(bas,'MT') || max(latstore(:,1)) >= 55   %  For Mediterranean basin, or polar lows rectify longitudes
    for i=1:nn
        for j=1:m
            if longstore(i,j) >= 200
                longstore(i,j)=longstore(i,j)-360.001;  %#ok<SAGROW> The 0.001 prevents artificial zeros
            end
        end    
    end
end    
%}
if strcmp(mapmode,'auto')
    xmin=min(nonzeros(longstore))-dellong;
    xmax=max(nonzeros(longstore))+dellong;
    ymin=min(nonzeros(latstore))-dellat;
    ymax=max(nonzeros(latstore))+dellat;
    xmin=mres*floor(xmin/mres);
    xmax=mres*ceil(xmax/mres);
    ymin=mres*floor(ymin/mres);
    ymax=mres*ceil(ymax/mres);
else
    xmin=longmin;
    xmax=longmax;
    ymin=latmin;
    ymax=latmax;
end 
if ((strcmp(bas,'AL') || strcmp(bas,'AP')) && max(latstore(:,1)) < 55) || strcmp(bas,'EW')
    xmin=max(xmin,180);
    xmax=min(xmax,360);
    ymin=max(ymin,0);
    %ymax=80;
%elseif strcmp(bas,'GB')
%    xmin=0;
%    xmax=360;
%    ymin=-84;
%    ymax=84;
end    
x=xmin:mres:xmax;
y=ymin:mres:ymax;
an=max(size(y));
am=max(size(x));
z=zeros(an,am);
%
vmax2(:,1)=ceil(min(max(vmax-peakv,0),1));  
vmax3=repmat(vmax2,[1,m]);
%vmax3=ceil(min(max(vnet-peakv,0),1));   % Use this to filter by LOCAL wind speed
atemp=ismember((min(yearstore):max(yearstore)),yearstore);
atemp=cast(atemp,'like',yearstore);
yearset=nonzeros(atemp.*(min(yearstore):max(yearstore)));
[~,nyy]=ismember(yearstore,yearset);
freqmask=freqyear(nyy);
freqmask2=repmat(freqmask,[1,m]);
dum=nonzeros(vmax3'.*latstore'.*latmask');
latr=mres*floor(dum/mres);
latr=latr+mod(y(1),mres);
dum=nonzeros(vmax3'.*(longstore+0.001)'.*latmask');
longr=mres*floor(dum/mres);
longr=longr+mod(x(1),mres);
clear dum
vl=ceil(min(max((nonzeros(vmax3'.*vnet'.*latmask')-minv),0),1));
%
[latl,ay]=ismember(latr,y);
[longl,ax]=ismember(longr,x);
ax=max(ax,1);
ay=max(ay,1);
%
N=max(size(vl));
den=freqmask2(1:N)'.*vl(1:N).*latl(1:N).*longl(1:N)./cos(pifac*latr(1:N));
%
for i=2:N
    if ay(i) ~= ay(i-1) || ax(i) ~= ax(i-1)  % This test insures that each track is counted only once per lat-long box
                                             % though it will count tracks that leave a box and then re-enter it
        z(ay(i),ax(i))=z(ay(i),ax(i))+den(i);
    end    
end
%
z=z./(nn*mres^2);
%
% Calculate new map limits
%
imin=1;
imax=an;
kmin=1;
kmax=am;
if strcmp(mapmode,'auto')
    xmin1=xmax;
    xmax1=xmin;
    ymin1=ymax;
    ymax1=ymin;
    kmin=am;
    kmax=1;
    imin=an;
    imax=1;
    zcrit=0.01*max(max(z));
    for j=1:an
        for k=1:am
            if z(j,k) > zcrit
                xmin1=min(xmin1,x(k));
                xmax1=max(xmax1,x(k));
                ymin1=min(ymin1,y(j));
                ymax1=max(ymax1,y(j));
                kmin=min(kmin,k);
                kmax=max(kmax,k);
                imin=min(imin,j);
                imax=max(imax,j);
            end    
        end
    end    
    xmin=xmin1;
    ymin=ymin1;
    xmax=xmax1;
    ymax=ymax1;
end
%if strcmp(bas,'AL') || strcmp(bas,'EW')
%    xmin=max(xmin,220);
%    xmax=min(xmax,360);
%    ymin=max(ymin,0);
%    ymax=80;
%end
%
clf('reset')
m_proj(projection,'long',[xmin xmax],'lat',[ymin ymax]);
m_gridm('fontname',axisfont,'fontsize',axisfontsize,'fontweight',axisfontweight, ...
    'linestyle',gridline,'backgroundcolor',oceancolor)
%
if strcmp(bas,'MT')
     m_gshhs_l('patch',landcolor,'edgecolor','none');
else     
     m_coast('patch',landcolor,'edgecolor','none');
end   
if strcmp(pstates,'y')
    m_states(xmin, xmax, ymin, ymax,'color',stcolor)
end  
hold on
%[C,h]=m_contourf(x(kmin:kmax),y(imin:imax),z(imin:imax,kmin:kmax),15);
cmax=(max(max(z(imin:imax,kmin:kmax))));
cint=cmax/15;
if verLessThan('matlab', '8.5.0') && strcmp(wfill,'y') %  Apply this to pre 2015 (R2014b) matlab versions
    [C,h]=m_contourf(x(kmin:kmax),y(imin:imax),z(imin:imax,kmin:kmax),cint:cint:cmax);
    thismap = get(gcf, 'Colormap');
    thismap(1,:)=[1 1 1];
    colormap(thismap)
    clear alpha
    alpha(0.99)
    hPatch = findobj(h,'Type','patch');
    set(hPatch,'facealpha',wtrans); 
    set(findobj(h,'FaceColor',[1 1 1]), 'FaceAlpha',0)
else
    %cmin=(min(min(z(imin:imax,kmin:kmax))));
    %[C,h]=m_contour(x(kmin:kmax),y(imin:imax),z(imin:imax,kmin:kmax),cint:cint:cmax) % This was changed on 2/8/2017
    %
    %h1=m_contour(x(kmin:kmax),y(imin:imax),z(imin:imax,kmin:kmax),cint:cint:cmax);
    h1=m_contour(x(kmin:kmax),y(imin:imax),z(imin:imax,kmin:kmax));
    if strcmp(wfill,'y')
        %z(z<0.08*max(max(z)))=NaN;
        h=m_pcolor(x(kmin:kmax),y(imin:imax),z(imin:imax,kmin:kmax));
        a=colormap(wmap);
        for i=1:3
            a(i,:)=oceancolor;
        end
        colormap(a)
        set(h,'EdgeAlpha',0,'FaceAlpha',wtrans);
        set(h,'FaceColor','interp');
    end
end    
%
jj=colorbar;
set(jj,'fontname',axisfont,'fontweight','bold')
cbIm = findobj(jj,'Type','image');
alpha(cbIm,wtrans)
yvec=get(jj,'ylim');
yvec(1,1)=0.1*yvec(1,2);
set(jj,'ylim',yvec)
hold off
%
if isempty(storm)
    datea(1)=upper(datea(1));
    tit1=datea;
else
    tit1=[storm(1:2) ' ' storm(3:4) ' ' datea(1:4) ' ' datea(5:6) ' ' datea(7:8)...
    ' ' datea(9:10) ' GMT'];
end   
tita='Track Density';
tittot={tita;tit1};
title(tittot,'fontsize',12,'fontweight','bold','interpreter','none')
%
if strcmp(bas,'MT') || max(latstore(:,1)) >= 55  %  For Mediterranean basin, and polar lows reset longitudes
    load temp longstore
end
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 