function [ro] = roquick(T600store,rmstore,vstore)
%
% This function estimates the outer radius (km) as a function of the
% maximum circular wind speed (vstore; kts), radius of maximum winds
% (rmstore; km) and subsidence velocity, which is estimated from the 600
% hPa temperature (T600store; K) used to calculate a moist adiabatic lapse
% rate, and an assumed constant radiative cooling of the mid troposphere.
% It is a curve fit to the results of rmlookup.m, holding the drag
% coefficient and f constant. It is pretty well correlated with the latter
% (r^2=0.999). 
%
% January, 2020
% Modified January 2024 to give better fit to Chavas and Emanuel (2010)
%     observed outer radii. 
%-------------------------------------------------------------------------
    Lv=2.5e6;
    cp=1005;
    Rv=461;
    Rd=287;
    g=9.8;
    dTdt=1.5/(24.*3600);   % Assumed radiative cooling rate (K/s)
             % Changed from 1 to 1.5 K/day, January, 2024
    %
    % First calculate subsidence velocity
    %
    Tc=T600store-273.15;
    Tc=max(Tc,-100);
    Ta=T600store;
    Ta=max(Ta,1);
    es=6.112.*exp(17.67.*Tc./(243.5+Tc));
    qs=0.622.*es./(600-es);
    S=(g*Lv.*qs./(cp.*Rd.*Ta)).*(0.622.*Lv./(cp.*Ta)-1)./ ...
        (1+Lv.^2.*qs./(cp.*Rv.*Ta.^2));
    ws=1.54*dTdt./S;   %   Calibrate ws using 1.54
    ws(T600store==0)=0;
    %
    % Now use curve fit to estimagte outer radius
    %
    ro=0.11115.*rmstore.^0.6859.*vstore.^0.7778.*ws.^-0.438+117;
    ro=0.75*ro;    % Modification of January, 2024
    ro(vstore==0)=0;
end