%
% This script overlays the first points of each best track (for which the
% winds speed > startv), filtered (if desired) to include only those 
% events whose winds speeds exceed some threshold and pass through the
% filter specified in gendensity, which must be run first. 
% Copyright 2012 WindRiskTech L.L.C.
% Last modified August, 2015
%-----------------------------------------------------------------------
%
if exist('shape','var') == 0 || exist('x','var') == 0
    f=msgbox('Need to run genpoints before running this script');
    return
end   
%
params    %  Load parameters
%
clear x2 y2
%
bestproc   %  Process best tracks
%
[nn,m]=size(vbest);
[~,jmax]=min(vbest,[],2);
jmax=jmax-1;
%
[~,jmin]=min(max((startv-vbest),0),[],2);
%
x2=zeros(1,nn);
y2=zeros(1,nn);
n=0;
load('temp','bas')
for i=1:nn
    if vmaxb(i) >= peakv && vbest(i,jmin(i)) >= startv && ...
           n <= nmax 
      n=n+1;
      x2(n)=longbest(i,jmin(i));
      y2(n)=latbest(i,jmin(i));
      if strcmp(bas,'MT') && x2(n) > 300
          x2(n)=x2(n)-360;
      end
    end
end
x2(n+1:nn)=[];
y2(n+1:nn)=[];
%
hold on
sc=m_plot(x2,y2,'b.');
set(sc,'markersize',genptsizebest)
%m_gshhs_l('patch',landcolor,'edgecolor','none');
%if strcmp(pstates,'y')
%    m_states(xmin, xmax, ymin, ymax,'color',stcolor)
%end 
%m_gridm('fontname',axisfont,'fontsize',axisfontsize,'fontweight',axisfontweight,'linestyle','none')
hold off
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    delete(hButton)
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 