%
%  This script overlays best tracks on track maps created using alltrplot,
%  which must be run directly before this script is executed.
%  June, 2011.  
%  Copyright 2011 WindRiskTech L.L.C.
%  Last modified August, 2015
%
%------------------------------------------------------------------------
%
if exist('shape','var') == 0 || exist('xmax','var') == 0
    f=msgbox('Need to run alltrplotmt before running this script');
    return
end   
%
params    %  Load parameters
%
prompt = {'Order by maximum at POI (1), maximum near POI (2), lifetime maximum (3), or random (4)?', ...
           'Number of tracks to plot'};
dlg_title = 'Best Track Parameters';
num_lines = 1;
answer = inputdlg(prompt,dlg_title,num_lines);
if isempty(answer) || isempty(answer{1})
    return
end    
nswitch=str2double(answer{1});
if (strcmp(shape,'poly') || city_radius >= 2000) && nswitch == 1
    warndlg('Warning: Winds at POI not meaningful for this set; ordering by maximum near POI')
    nswitch=2;
end    
ntracks=str2double(answer{2});
%
bestproc   %  Process best tracks
%
yearbeg=min(bestyears);
yearend=max(bestyears);
rng('shuffle')   %  Set seed of random number generator based on time
%
% Find tracks, allowing for one potential wrap in longitude
%
nact=min(ntracks,max(size(nsortb)));
for k=1:nact
   if nswitch == 3
   %
   % Ordered by most intense over lifetime
   %
   i=nsortb(k);
   %
   elseif nswitch == 2
   %
   % Ordered by most intense near POI
   %
   i=nsortpb(k);
   %
   elseif nswitch == 1
   %
   % Ordered by most intense at POI
   %
   i=nsortcb(k);
   %
   elseif nswitch == 4
   %
   % Randomly ordered
   %
   i=1+floor((max(nsortb)-1).*rand);
   %
   end
    np1=0;
    np2=0;
    ntrack=1;
    [~, jmax]=min(vbest(i,:),[],2);
    jmax=jmax-1;
    clear x y x2 y2 v v2
    x=zeros(1,jmax);
    y=x;
    v=x;
    for j=1:jmax
          np1=np1+1;
          y(np1)=latbest(i,j);
          x(np1)=longbest(i,j);
          if j > 1 && x(1) > 200 && x(np1) < 10
              x(np1)=x(np1)+360;
          end    
          v(np1)=vbest(i,j);
          xmax=max(xmax,x(np1));
          xmin=min(xmin,x(np1));
          ymax=max(ymax,y(np1));
          ymin=min(ymin,y(np1));
    end    
    x(np1+1:end)=[];
    y(np1+1:end)=[];
    v(np1+1:end)=[];
    if np1 > 1
        plotm(y(1:np1),x(1:np1),'color',besttckcolor,'linewidth',2*besttckwidth) 
%    end    
%
% Put arrowheads on tracks
%
%   if np1 > 1
       ua=x(np1)-x(np1-1);
       va=y(np1)-y(np1-1);
       mag=sqrt(ua^2+va^2);
       ua=5*ua/mag;
       va=5*va/mag;
       xq=x(np1);
       yq=y(np1);
       g1=quiverm(yq,xq,0.8*va,0.8*ua,0);
       set(g1,'linewidth',besttckwidth)
       set(g1,'color',besttckcolor) 
       xb=x(1);
       yb=y(1);
       g2=plotm(yb,xb,'.','color',besttckcolor,'markersize',floor(12.*besttckwidth));
   end    
end   
%
% Add button to access documentation of script
%
if strcmp(Docdisp,'y')
    delete(hButton)
    tempname=mfilename;
    mname = strcat('graphics_docs/html/',tempname,'_doc.html');
    comstr=['open ',mname,';delete(hButton)'];
    labelStr = '<html><center><a href="">Doc';
    hButton = uicontrol('string',labelStr,'pos',[10,10,50,20],'callback',comstr); 
end
%
% Clean up
%
if strcmp(Clearvlbs,'y')
    clearvars('-except',protected_variables{:})
end 